require( "scripts/style.lua" );


LockedFont = {
  standardFont,
  18,
  RedColor
};

SaveToProfileFont = {
  standardFont,
  14,
  WhiteColor
};

PrivacyFont = {
  standardFont,
  10,
  WhiteColor
};

MoreItemsFont = {
  standardFont,
  24,
  BorderColor
};

NoColorsFont = {
  standardFont,
  14,
  WhiteColor
};

function MakeNoColorsText(descrip)
	MakeDialog
	{
		Text
		{
			x = 10, y = 0,
			w = kMax-10, h = kMax,
			font = NoColorsFont,
			label = descrip,
			flags = kHAlignCenter + kVAlignCenter
		}
	}
end



function FadeFromGame()
	local id = PushModal( 'flosclosetfade' );
	MakeDialog
	{
		TimedFade
		{
			x=0,
			y=0,
			w=800,
			h=600,
			length = 1,
			
		},
	};
	

	WaitForCloseMessage(id);
	
	DoModal('scripts/clothingunlock.lua');
	
end

HairButtonGraphics = {
	"floscloset/ui/icon_hair_button_a",
	"floscloset/ui/icon_hair_button_b",
	"floscloset/ui/icon_hair_button_a"
};

FaceButtonGraphics = {
	"floscloset/ui/icon_face_button_a",
	"floscloset/ui/icon_face_button_b",
	"floscloset/ui/icon_face_button_a"
};

ApronButtonGraphics = {
	"floscloset/ui/icon_apron_button_a",
	"floscloset/ui/icon_apron_button_b",
	"floscloset/ui/icon_apron_button_a"
};

HatButtonGraphics = {
	"floscloset/ui/icon_hat_button_a",
	"floscloset/ui/icon_hat_button_b",
	"floscloset/ui/icon_hat_button_a"
};

PantButtonGraphics = {
	"floscloset/ui/icon_pant_button_a",
	"floscloset/ui/icon_pant_button_b",
	"floscloset/ui/icon_pant_button_a"
};

ShirtButtonGraphics = {
	"floscloset/ui/icon_shirt_button_a",
	"floscloset/ui/icon_shirt_button_b",
	"floscloset/ui/icon_shirt_button_a"
};

ShoesButtonGraphics = {
	"floscloset/ui/icon_shoes_button_a",
	"floscloset/ui/icon_shoes_button_b",
	"floscloset/ui/icon_shoes_button_a"
};

RackButtonGraphics = {
	"floscloset/ui/icon_button_a",
	"floscloset/ui/icon_button_c",
	"floscloset/ui/icon_button_b",
	"floscloset/ui/icon_button_c"	
};

kClothingXPos = 440;
kClothingXSpacing = 120;
kClothingY1 = 21;
kClothingY2 = 192;
kClothingY3 = 365;




kRackButtonY = 10;
kRackButtonSpacing = 80;

kUIToClothing = {4,5,6,2,1,3,0};





function MakeLockedIcon(i, xVal, yVal)
	return Group {
		Bitmap
		{
			name="lockedicon"..i,
			image="floscloset/ui/clothes_locked",
			x =xVal,
			y=yVal,
			
			Text 
			{
				x=10,y=20,w=kMax-10,h=kMax-20,
				font = LockedFont,
				name = "lockediconlabel"..i,
				label = "",
				flags = kHAlignCenter + kVAlignTop,
				spacing = 0
				
			};
		};
	}
end

kLockedIconWidth = 59;
function MakeLockedIcons()
	local windows = {};
	for i=0,2 do
		table.insert(windows, MakeLockedIcon(i, kClothingXPos + (i * kClothingXSpacing) - kLockedIconWidth, kClothingY1));
	end;
	for i=3,5 do
		table.insert(windows, MakeLockedIcon(i, kClothingXPos + ((i-3) * kClothingXSpacing) - kLockedIconWidth, kClothingY2));
	end;
	for i=6,8 do
		table.insert(windows, MakeLockedIcon(i, kClothingXPos + ((i-6) * kClothingXSpacing) - kLockedIconWidth, kClothingY3));
	end;
	return Group(windows);
end


function MakeRackButton(i, graphicType)
	return Button {
		name="rackbutton"..i,
		graphics=RackButtonGraphics,
		x = 252,
		y=kRackButtonY + (kRackButtonSpacing * i),
		SelectLayer(0);
		Bitmap
		{
			x = kCenter,
			y = kCenter,
			image = graphicType[1]
		};
		SelectLayer(1);
		Bitmap
		{
			x = kCenter + 2,
			y = kCenter + 2,
			image = graphicType[1]
		};
		SelectLayer(2);
		Bitmap
		{
			x = kCenter,
			y = kCenter,
			image = graphicType[1]
		};
		
		SelectLayer(3);
		Bitmap
		{
			x = kCenter + 2,
			y = kCenter + 2,
			image = graphicType[1]
		};
		
		command=
				function()
					SetRackType(kUIToClothing[i+1]);
				end
			
	};
end

if (UseMyWaiter()) then
	removeX = 510;
	removeY = 80;
else
	removeX = 387;
	removeY = 80;
end


function MakeMyWaiterButtons()
	if (UseMyWaiter()) then
		return Group {
			Button{
				graphics = CheckboxButtonGraphics,
				name="savemywaiter",
				type = kToggle,
				x=460,
				y=565,
				w=200,
				tx = 25,
				ty = 10,
				xoffset = 0,
				yoffset = 0,
				scale = 0.5,
				label = 'mw_savetoprofile',
				font = SaveToProfileFont,
				flags = kHAlignLeft + kVAlignTop,
				command =
					function()
						curSetting = GetBoolSetting('savewaitertoprofile', false);
						SetBoolSetting('savewaitertoprofile', not curSetting);
						if (not GetBoolSetting('savewaitertoprofileinfo', false)) then
							SetBoolSetting('savewaitertoprofileinfo', true);
							--DisplayDialog{
							--	'scripts/ok.lua', 
							--	body ='mw_firstsavetoprofile',
							--	title = ''
							--};
						end
					end
				
			};
			
			LinkText
			{
				label = 'mw_shoppanel',
				font = MoreItemsFont,
				x = kClothingXPos-kLockedIconWidth,
				y = 18,
				w = kLockedIconWidth*2,
				h = 167,
				flags = kHAlignCenter + kVAlignCenter
			};
			
			LinkText
			{
				label = 'privacybutton',
				font = PrivacyFont,
				x = 330,
				y = 575,
				w = kMax,
				h = kMax,
				flags = kHAlignLeft + kVAlignTop
			};
			
			LinkText
			{
				label = 'tosbutton',
				font = PrivacyFont,
				x = 380,
				y = 575,
				w = kMax,
				h = kMax,
				flags = kHAlignLeft + kVAlignTop
			};
			
			SetStyle(DefaultStyle);
			Button
			{
				x = 0, y = 0, w = 0, h = 0,
				name = 'privacybutton',
				command = 
					function()
						LaunchHarnessPost('manager', 'content', '../privacypolicy.html');
					end
			};
			
			Button
			{
				x = 0, y = 0, w = 0, h = 0,
				name = 'tosbutton',
				command = 
					function()
						LaunchHarnessPost('manager', 'content', '../tos.html');
					end
			};
			
			SetStyle(ClosetButtonStyle);
			Button
			{
				x=130,
				y=570,
				name="mw_shop",
				label="mw_shop",
				type = kPush,
				command=
					function()
						LaunchStore("paperdoll");
					end
			},

			
			
		};
	else
		return Group {
		
		};
	end
end

MakeDialog
{
	SetStyle(DefaultStyle);
	
	Bitmap
	{
		name="backgroundimage",
		image="floscloset/ui/bg",
		x=0,y=0,w=kMax,h=kMax,
		
		
		
		SetStyle(ClosetButtonStyle);
		
		
		Button
		{
			x=670,
			y=570,
			name="done",
			label="done",
			type = kPush,
			command=
				function()
					HideMainMenu(true);
					ClearNewClothing();
					SaveOutfit();
					if (UseMyWaiter()) then
						SaveThumbnail(true);
						if (GetBoolSetting('savewaitertoprofile', false) == true) then
							SaveWaiterToProfile();
						end
					end
					PostMessage( CreateNamedMessage( kClothingChanged, "kClothingChanged" ) );
					PopModal("scripts/floscloset.lua");
				end
		},
		
		Button
		{
			x=removeX,
			y=removeY,
			name="removeitem",
			label="removeitem",
			type = kPush,
			command=
				function()
					RemoveItem();
				end
		},
		
		Button
		{
			x=20,
			y=570,
			name="shuffle",
			label="shuffle",
			type = kPush,
			command=
				function()
					RecordCurrentSettings();
					shuffleResult = 'choice2';				
					while (shuffleResult == 'choice2') do
						Shuffle(true, false);
						shuffleResult = DisplayDialog { 
							"scripts/threechoices.lua", 
							body ="mw_shufflequestion",
							title = "",
							choice1label="mw_keepshuffle",
							choice2label="mw_shuffleagain",
							choice3label="mw_cancelshuffle"
						};
					end
					if (shuffleResult == 'choice3') then
						RestoreCurrentSettings();
					end
					
				end
		},
		
		FlosCloset
		{
			x=0,y=0,w=kMax,h=kMax,
			fit=false,
			clothingXPos = kClothingXPos,
			clothingXSpacing = kClothingXSpacing,
			clothingY1 = kClothingY1,
			clothingY2 = kClothingY2,
			clothingY3 = kClothingY3,
			swatchX = -10 ,
			swatchSpacing = 25,
			swatchY = 115,
			swatchButtonX = 23,
			swatchButtonY = 15,
			swatchButtonY2 = 40,
			newItemX = 25,
			newItemY = 25,
			name='floscloset',
			

			MakeLockedIcons(),
			
			
			Window {
  				SetStyle(RadioButtonStyle);			
				BeginGroup();			
				MakeRackButton(0, FaceButtonGraphics);
				MakeRackButton(1, HairButtonGraphics);
				MakeRackButton(2, HatButtonGraphics);
				MakeRackButton(3, ShirtButtonGraphics);
				MakeRackButton(4, PantButtonGraphics);
				MakeRackButton(5, ApronButtonGraphics);
				MakeRackButton(6, ShoesButtonGraphics);
			};
  			
  			SetStyle(ClosetArrowLeftButtonStyle);
  			Button
  			{
  				name = 'iconleft',
  				x = 343,
  				y = 250,
  				command=
  					function()
  						AdvanceRack(-1);
  					end
  				
  			};
  			
  			
  			SetStyle(ClosetArrowRightButtonStyle);
  			Button
  			{
  				name = 'iconright',
  				x = 746,
  				y = 250,
  				command=
  					function()
  						AdvanceRack(1);
  					end
  			};
  			
  			
  			SetStyle(RadioButtonStyle);
  			BeginGroup();
  			Button
  			{
  				x = 150,
  				y = 545,
  				w = 85,
  				name = "male",
  				label = "male",
  				command=
  					function()
  						SetClosetModel("male_waiter");
  					end
  			};
  			
  			Button
  			{
  				x = 65,
  				y = 545,
  				w = 85,
  				name = "female",
  				label = "female",
  				command=
  					function()
  						SetClosetModel("flo");
  					end
  			};
  			
  			SetStyle(DefaultButtonStyle);
			
			
			
		};
		
		MakeMyWaiterButtons();
		
		
		
			
	},
	
};

HideMainMenu(false);
ActivateHelpClock(true);
MetricEvent(eClosetVisits);

if (UseMyWaiter()) then
	SetBoolSetting('todolist_mywaiter', true);
	if (GetBoolSetting('savewaitertoprofile', false) == true) then
		SetChecked('savemywaiter', true);
	end
	EnforceOnlineBuild();
end